/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FilenameFilter;

public class MCLDataFileFilter
implements FilenameFilter {
    private static final String TRACE_MASKT = "XMCLfilT";
    private static final String TRACE_MASKF = "XMCLfilF";
    private static final String TRACE_MASKD = "XMCLfilD";
    String testString;
    int firstLevel;
    int lastLevel;
    boolean anyEC;

    public MCLDataFileFilter(String ecNumber, int firstLevel, int lastLevel) {
        this.testString = "D" + ecNumber + ".";
        this.firstLevel = firstLevel;
        this.lastLevel = lastLevel;
        this.anyEC = false;
        Trace.trace(TRACE_MASKT, "<> MCLDataFileFilter for [" + this.testString + "]");
    }

    public MCLDataFileFilter() {
        this.anyEC = true;
        Trace.trace(TRACE_MASKT, "<> MCLDataFileFilter for any MCLs");
    }

    public boolean accept(File dir, String name) {
        String compareString;
        Trace.trace(TRACE_MASKD, "-> accept(" + name + ")");
        boolean inec = false;
        if (this.anyEC) {
            int dotPosition;
            char firstChar = name.charAt(0);
            if ((firstChar == 'D' || firstChar == 'd') && (dotPosition = name.indexOf(".")) == 7 && name.length() == dotPosition + 4) {
                inec = true;
            }
        } else if (name.length() >= this.testString.length() && (compareString = name.substring(0, this.testString.length()).toUpperCase()).equals(this.testString)) {
            try {
                int level = Integer.parseInt(name.substring(this.testString.length()), 10);
                Trace.trace(TRACE_MASKD, "level = " + level);
                if (level >= this.firstLevel && level <= this.lastLevel) {
                    inec = true;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        Trace.trace(TRACE_MASKD, "<- accept() returns " + (inec ? "true" : "false"));
        return inec;
    }
}

